/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.lang.BaseObject;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\net\\Socket")
public class WrapSocket
extends BaseObject {
    protected Socket socket;

    public WrapSocket(Environment env, Socket socket) {
        super(env);
        this.setSocket(socket);
    }

    public WrapSocket(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="host", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="port", optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        if (args[0].isNull() && args[1].isNull()) {
            this.setSocket(new Socket());
        } else {
            this.setSocket(new Socket(args[0].toString(), args[1].toInteger()));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getOutput(Environment env, Memory ... args) throws IOException {
        return new ObjectMemory(new MiscStream(env, this.socket.getOutputStream()));
    }

    @Reflection.Signature
    public Memory getInput(Environment env, Memory ... args) throws IOException {
        return new ObjectMemory(new MiscStream(env, this.socket.getInputStream()));
    }

    @Reflection.Signature
    public Memory close(Environment env, Memory ... args) throws IOException {
        this.socket.close();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory shutdownInput(Environment env, Memory ... args) throws IOException {
        this.socket.shutdownInput();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory shutdownOutput(Environment env, Memory ... args) throws IOException {
        this.socket.shutdownOutput();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isBound(Environment env, Memory ... args) {
        return this.socket.isBound() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isClosed(Environment env, Memory ... args) {
        return this.socket.isClosed() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isConnected(Environment env, Memory ... args) {
        return this.socket.isConnected() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInputShutdown(Environment env, Memory ... args) {
        return this.socket.isInputShutdown() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isOutputShutdown(Environment env, Memory ... args) {
        return this.socket.isOutputShutdown() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="hostname"), @Reflection.Arg(value="port"), @Reflection.Arg(value="timeout", optional=@Reflection.Optional(value="NULL"))})
    public Memory connect(Environment env, Memory ... args) throws IOException {
        if (args[2].isNull()) {
            this.socket.connect(new InetSocketAddress(args[0].toString(), args[1].toInteger()));
        } else {
            this.socket.connect(new InetSocketAddress(args[0].toString(), args[1].toInteger()), args[2].toInteger());
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="hostname"), @Reflection.Arg(value="port")})
    public Memory bind(Environment env, Memory ... args) throws IOException {
        this.socket.bind(new InetSocketAddress(args[0].toString(), args[1].toInteger()));
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory bindDefault(Environment env, Memory ... args) throws IOException {
        this.socket.bind(null);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getLocalAddress(Environment env, Memory ... args) {
        return new StringMemory(this.socket.getLocalAddress().toString());
    }

    @Reflection.Signature
    public Memory getLocalPort(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.socket.getLocalPort());
    }

    @Reflection.Signature
    public Memory getPort(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.socket.getPort());
    }

    @Reflection.Signature
    public Memory getAddress(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.socket.getInetAddress().toString());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeout")})
    public Memory setSoTimeout(Environment env, Memory ... args) throws SocketException {
        this.socket.setSoTimeout(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on"), @Reflection.Arg(value="linger")})
    public Memory setSoLinger(Environment env, Memory ... args) throws SocketException {
        this.socket.setSoLinger(args[0].toBoolean(), args[1].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on")})
    public Memory setReuseAddress(Environment env, Memory ... args) throws SocketException {
        this.socket.setReuseAddress(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on")})
    public Memory setTcpNoDelay(Environment env, Memory ... args) throws SocketException {
        this.socket.setTcpNoDelay(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on")})
    public Memory setKeepAlive(Environment env, Memory ... args) throws SocketException {
        this.socket.setKeepAlive(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on")})
    public Memory setOOBInline(Environment env, Memory ... args) throws SocketException {
        this.socket.setOOBInline(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="size")})
    public Memory setReceiveBufferSize(Environment env, Memory ... args) throws SocketException {
        this.socket.setReceiveBufferSize(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="size")})
    public Memory setSendBufferSize(Environment env, Memory ... args) throws SocketException {
        this.socket.setSendBufferSize(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="connectTime"), @Reflection.Arg(value="latency"), @Reflection.Arg(value="bandWidth")})
    public Memory setPerformancePreferences(Environment env, Memory ... args) throws SocketException {
        this.socket.setPerformancePreferences(args[0].toInteger(), args[1].toInteger(), args[2].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="tc")})
    public Memory setTrafficClass(Environment env, Memory ... args) throws SocketException {
        this.socket.setTrafficClass(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="data")})
    public Memory sendUrgentData(Environment env, Memory ... args) throws IOException {
        this.socket.sendUrgentData(args[0].toInteger());
        return Memory.NULL;
    }
}

