/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionExtension;
import php.runtime.ext.core.reflection.ReflectionType;
import php.runtime.ext.support.Extension;
import php.runtime.lang.Closure;
import php.runtime.lang.IObject;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.CompileFunctionEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;
import php.runtime.reflection.support.TypeChecker;

public abstract class ReflectionFunctionAbstract
extends Reflection {
    public ReflectionFunctionAbstract(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ReflectionFunctionAbstract(Environment env) {
        super(env);
    }

    protected IObject getInstance() {
        return null;
    }

    protected abstract AbstractFunctionEntity getEntity();

    protected ClosureEntity getClosureEntity() {
        return null;
    }

    @Reflection.Signature
    public Memory getClosureScopeClass(Environment env, Memory ... args) {
        IObject instance = this.getInstance();
        if (instance == null || !(instance instanceof Closure)) {
            return Memory.NULL;
        }
        return new StringMemory(((Closure)instance).getScope());
    }

    @Reflection.Signature
    public Memory getClosureThis(Environment env, Memory ... args) {
        IObject instance = this.getInstance();
        if (instance == null || !(instance instanceof Closure)) {
            return Memory.NULL;
        }
        return ((Closure)instance).getSelf();
    }

    @Reflection.Signature
    public Memory getDocComment(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.NULL;
        }
        if (this.getEntity().getDocComment() == null) {
            return Memory.NULL;
        }
        return new StringMemory(this.getEntity().getDocComment().toString());
    }

    @Reflection.Signature
    public Memory getEndLine(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return LongMemory.valueOf(this.getClosureEntity().getTrace().getEndLine());
        }
        return LongMemory.valueOf(this.getEntity().getTrace().getEndLine());
    }

    @Reflection.Signature
    public Memory getExtension(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.NULL;
        }
        Extension extension = this.getEntity().getExtension();
        if (extension == null) {
            return Memory.NULL;
        }
        ReflectionExtension ext = new ReflectionExtension(env, env.fetchClass("ReflectionExtension"));
        ext.setExtension(extension);
        return new ObjectMemory(ext);
    }

    @Reflection.Signature
    public Memory getExtensionName(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.FALSE;
        }
        Extension extension = this.getEntity().getExtension();
        if (extension == null) {
            return Memory.FALSE;
        }
        return new StringMemory(extension.getName());
    }

    @Reflection.Signature
    public Memory getFileName(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return new StringMemory(this.getClosureEntity().getTrace().getFileName());
        }
        return new StringMemory(this.getEntity().getTrace().getFileName());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.FALSE;
        }
        return new StringMemory(this.getEntity().getName());
    }

    @Reflection.Signature
    public Memory getNamespaceName(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.FALSE;
        }
        return new StringMemory(this.getEntity().getNamespaceName());
    }

    @Reflection.Signature
    public Memory getNumberOfParameters(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return LongMemory.valueOf(this.getClosureEntity().parameters.length);
        }
        return LongMemory.valueOf(this.getEntity().getParameters().length);
    }

    @Reflection.Signature
    public Memory getNumberOfRequiredParameters(Environment env, Memory ... args) {
        ParameterEntity[] parameterEntities;
        int cnt = 0;
        for (ParameterEntity e : parameterEntities = this.getClosureEntity() == null ? this.getEntity().getParameters() : this.getClosureEntity().parameters) {
            if (e.getDefaultValue() != null) continue;
            ++cnt;
        }
        return LongMemory.valueOf(cnt);
    }

    @Reflection.Signature
    public Memory getShortName(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.NULL;
        }
        return new StringMemory(this.getEntity().getShortName());
    }

    @Reflection.Signature
    public Memory getStartLine(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return LongMemory.valueOf(this.getClosureEntity().getTrace().getStartLine() + 1);
        }
        return LongMemory.valueOf(this.getEntity().getTrace().getStartLine() + 1);
    }

    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return LongMemory.valueOf(this.getClosureEntity().getTrace().getStartPosition() + 1);
        }
        return LongMemory.valueOf(this.getEntity().getTrace().getStartPosition() + 1);
    }

    @Reflection.Signature
    public Memory getStaticVariables(Environment env, Memory ... args) {
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory inNamespace(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.FALSE;
        }
        return this.getEntity().getNamespaceName().isEmpty() ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature
    public Memory isClosure(Environment env, Memory ... args) {
        return this.getClosureEntity() != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isDeprecated(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return Memory.FALSE;
        }
        return this.getEntity().isDeprecated() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInternal(Environment env, Memory ... args) {
        return this.getEntity() instanceof CompileFunctionEntity ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isUserDefined(Environment env, Memory ... args) {
        return this.getEntity() instanceof CompileFunctionEntity ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature
    public Memory returnsReference(Environment env, Memory ... args) {
        if (this.getClosureEntity() != null) {
            return this.getClosureEntity().isReturnReference() ? Memory.TRUE : Memory.FALSE;
        }
        return this.getEntity().isReturnReference() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory hasReturnType(Environment env, Memory ... args) {
        return this.getEntity().getReturnTypeChecker() != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getReturnType(Environment env, Memory ... args) {
        TypeChecker typeChecker = this.getEntity().getReturnTypeChecker();
        if (typeChecker == null) {
            return Memory.NULL;
        }
        String name = typeChecker.getSignature();
        boolean isBuiltin = typeChecker.isBuiltin();
        return ObjectMemory.valueOf(new ReflectionType(env, name, this.getEntity().isReturnTypeNullable(), isBuiltin));
    }

    @Reflection.Signature
    public abstract Memory getParameters(Environment var1, Memory ... var2);
}

