/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.java.JavaException;
import php.runtime.lang.BaseObject;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\JavaReflection")
public abstract class JavaReflection
extends BaseObject {
    protected static Map<Class<? extends JavaException>, Constructor<? extends JavaException>> constructors;
    protected static Map<Class<? extends Throwable>, Class<? extends JavaException>> cachedThClasses;

    public JavaReflection(Environment env) {
        super(env);
    }

    public JavaReflection(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public static void exception(Environment env, Throwable e) {
        JavaException exception;
        Class<?> tmp;
        Class<? extends JavaException> clazz;
        if (cachedThClasses == null) {
            cachedThClasses = new ConcurrentHashMap<Class<? extends Throwable>, Class<? extends JavaException>>();
        }
        if (constructors == null) {
            constructors = new ConcurrentHashMap<Class<? extends JavaException>, Constructor<? extends JavaException>>();
        }
        if ((clazz = cachedThClasses.get(tmp = e.getClass())) == null) {
            while (tmp != null) {
                clazz = env.scope.findJavaException(tmp);
                if (clazz != null) {
                    cachedThClasses.put(e.getClass(), clazz);
                    break;
                }
                tmp = tmp.getSuperclass();
            }
        }
        if (clazz == null) {
            for (ClassEntity context = env.getLastClassOnStack(); context != null && (clazz = env.scope.findJavaExceptionForContext(context.getLowerName())) == null; context = context.getParent()) {
            }
        }
        if (clazz == null) {
            exception = new JavaException(env, e);
        } else {
            try {
                Constructor<? extends JavaException> constructor = constructors.get(clazz);
                if (constructor == null) {
                    constructor = clazz.getConstructor(Environment.class, Throwable.class);
                    constructors.put(clazz, constructor);
                }
                exception = constructor.newInstance(env, e);
            }
            catch (InvocationTargetException e1) {
                throw new CriticalException(e1.getCause());
            }
            catch (Exception e1) {
                throw new CriticalException(e1);
            }
        }
        env.__throwException(exception, false);
    }
}

