/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import php.runtime.Memory;
import php.runtime.common.StringUtils;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.helper.BinaryCharArrayMemory;
import php.runtime.memory.helper.CharArrayMemory;

public class CharMemory
extends StringMemory {
    public final ReferenceMemory origin;
    public final int index;

    public CharMemory(String value, ReferenceMemory origin, int index) {
        super(value);
        this.index = index;
        this.origin = origin;
    }

    public static Memory valueOf(ReferenceMemory origin, StringMemory memory, int index) {
        if (index < 0 || index >= memory.value.length()) {
            return new CharMemory("", origin, index);
        }
        return new CharMemory(String.valueOf(memory.value.charAt(index)), origin, index);
    }

    private void makeString(String ch) {
        Memory v = this.origin.toValue();
        if (v instanceof CharArrayMemory) {
            CharArrayMemory charArray = (CharArrayMemory)v;
            charArray.put(this.index, ch);
        } else {
            String value = v.toString();
            int len = ch.length();
            if (len == 0) {
                ch = "\u0000";
            } else if (len > 1) {
                ch = String.valueOf(ch.charAt(0));
            }
            int len2 = value.length();
            StringBuilder builder = new StringBuilder(this.index > len2 - 1 ? value : value.substring(0, this.index));
            if (this.index > len2 - 1) {
                builder.append(StringUtils.repeat('\u001a', this.index - len2));
            }
            builder.append(ch);
            if (this.index < len2) {
                builder.append(value.substring(this.index + 1));
            }
            if (v instanceof BinaryMemory) {
                this.origin.assign(new BinaryCharArrayMemory(builder.toString()));
            } else {
                this.origin.assign(new CharArrayMemory(builder.toString()));
            }
        }
    }

    @Override
    public Memory assign(Memory memory) {
        this.makeString(memory.toString());
        return memory;
    }

    @Override
    public Memory assign(long value) {
        this.makeString(String.valueOf(value));
        return LongMemory.valueOf(value);
    }

    @Override
    public Memory assign(double value) {
        this.makeString(String.valueOf(value));
        return new DoubleMemory(value);
    }

    @Override
    public Memory assign(boolean value) {
        this.makeString(Memory.boolToString(value));
        return value ? TRUE : FALSE;
    }

    @Override
    public Memory assign(String value) {
        this.makeString(value);
        return new StringMemory(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharMemory that = (CharMemory)o;
        if (this.index != that.index) {
            return false;
        }
        return this.origin != null ? this.origin.equals(that.origin) : that.origin == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + this.index;
        return result;
    }
}

