/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.xml.classes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.develnext.jphp.ext.xml.classes.WrapDomDocument;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.format.WrapProcessor;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.java.JavaException;
import php.runtime.invoke.Invoker;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.ReflectionUtils;

@Reflection.Name(value="php\\xml\\XmlProcessor")
public class WrapXmlProcessor
extends WrapProcessor {
    protected DocumentBuilderFactory builderFactory;
    protected DocumentBuilder builder;
    protected TransformerFactory transformerFactory;
    protected Transformer transformer;
    protected Invoker onWarning;
    protected Invoker onError;
    protected Invoker onFatalError;

    public WrapXmlProcessor(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct(final Environment env) throws ParserConfigurationException, TransformerConfigurationException {
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformer = this.transformerFactory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = this.builderFactory.newDocumentBuilder();
        this.builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                if (WrapXmlProcessor.this.onWarning != null) {
                    WrapXmlProcessor.this.onWarning.callAny(new Object[]{new JavaException(env, (Throwable)exception)});
                }
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                if (WrapXmlProcessor.this.onError != null) {
                    WrapXmlProcessor.this.onError.callAny(new Object[]{new JavaException(env, (Throwable)exception)});
                }
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                if (WrapXmlProcessor.this.onFatalError == null) {
                    throw exception;
                }
                WrapXmlProcessor.this.onFatalError.callAny(new Object[]{new JavaException(env, (Throwable)exception)});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public Memory parse(Environment environment, Memory ... args) {
        ObjectMemory objectMemory;
        block8: {
            if (this.onWarning != null) {
                this.onWarning.setTrace(environment.trace());
            }
            if (this.onError != null) {
                this.onError.setTrace(environment.trace());
            }
            if (this.onFatalError != null) {
                this.onFatalError.setTrace(environment.trace());
            }
            InputStream stream = null;
            try {
                stream = args[0].instanceOf(Stream.class) ? Stream.getInputStream((Environment)environment, (Memory)args[0]) : new ByteArrayInputStream(args[0].getBinaryBytes(environment.getDefaultCharset()));
                Document document = this.builder.parse(stream);
                objectMemory = new ObjectMemory((IObject)new WrapDomDocument(environment, document));
                if (stream == null) break block8;
            }
            catch (IOException | SAXException e) {
                Memory memory;
                block9: {
                    try {
                        environment.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
                        memory = Memory.NULL;
                        if (stream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            Stream.closeStream((Environment)environment, stream);
                        }
                        throw throwable;
                    }
                    Stream.closeStream((Environment)environment, (InputStream)stream);
                }
                return memory;
            }
            Stream.closeStream((Environment)environment, (InputStream)stream);
        }
        return objectMemory;
    }

    @Reflection.Signature
    public Memory format(Environment environment, Memory ... args) {
        if (!args[0].instanceOf(WrapDomDocument.class)) {
            throw new IllegalArgumentException("Argument #1 must be instance of " + ReflectionUtils.getClassName(WrapDomDocument.class));
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            this.transformer.transform(new DOMSource(((WrapDomDocument)args[0].toObject(WrapDomDocument.class)).getWrappedObject()), result);
            return StringMemory.valueOf((String)writer.toString());
        }
        catch (TransformerException e) {
            environment.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
            return Memory.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public Memory formatTo(Environment environment, Memory ... args) {
        if (!args[0].instanceOf(WrapDomDocument.class)) {
            throw new IllegalArgumentException("Argument #1 must be instance of " + ReflectionUtils.getClassName(WrapDomDocument.class));
        }
        OutputStream output = Stream.getOutputStream((Environment)environment, (Memory)args[1]);
        StreamResult result = new StreamResult(output);
        try {
            this.transformer.transform(new DOMSource(((WrapDomDocument)args[0].toObject(WrapDomDocument.class)).getWrappedObject()), result);
        }
        catch (TransformerException e) {
            environment.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
            Memory memory = Memory.NULL;
            return memory;
        }
        finally {
            Stream.closeStream((Environment)environment, (OutputStream)output);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Document createDocument() {
        return this.builder.newDocument();
    }

    @Reflection.Signature
    public void onWarning(@Reflection.Nullable Invoker invoker) {
        this.onWarning = invoker;
    }

    @Reflection.Signature
    public void onError(@Reflection.Nullable Invoker invoker) {
        this.onError = invoker;
    }

    @Reflection.Signature
    public void onFatalError(@Reflection.Nullable Invoker invoker) {
        this.onFatalError = invoker;
    }
}

