/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.jfoenix.classes;

import com.jfoenix.controls.JFXTimePicker;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import org.develnext.jphp.ext.javafx.classes.UXComboBoxBase;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Namespace(value="php\\gui")
public class UXMaterialTimePicker
extends UXComboBoxBase<JFXTimePicker> {
    public UXMaterialTimePicker(Environment env, JFXTimePicker wrappedObject) {
        super(env, (ComboBoxBase)wrappedObject);
    }

    public UXMaterialTimePicker(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new JFXTimePicker();
    }

    @Reflection.Setter
    public void setFormat(String value) {
        ((JFXTimePicker)this.getWrappedObject()).setConverter((StringConverter)new CustomConverter(value));
    }

    @Reflection.Getter
    public String getFormat() {
        this.initFormat();
        StringConverter converter = ((JFXTimePicker)this.getWrappedObject()).getConverter();
        if (converter instanceof CustomConverter) {
            return ((CustomConverter)converter).format;
        }
        return null;
    }

    private void initFormat() {
        if (((JFXTimePicker)this.getWrappedObject()).getConverter() == null) {
            ((JFXTimePicker)this.getWrappedObject()).setConverter((StringConverter)new CustomConverter("HH:mm"));
        }
    }

    @Reflection.Getter
    public WrapTime getValueAsTime(Environment env) {
        this.initFormat();
        LocalTime value = (LocalTime)((JFXTimePicker)this.getWrappedObject()).getValue();
        if (value == null) {
            return null;
        }
        Instant instant = value.atDate(LocalDate.of(0, 0, 0)).atZone(ZoneId.systemDefault()).toInstant();
        return new WrapTime(env, Date.from(instant));
    }

    @Reflection.Setter
    public void setValueAsTime(Environment env, @Reflection.Nullable WrapTime time) {
        this.initFormat();
        if (time == null) {
            ((JFXTimePicker)this.getWrappedObject()).setValue(null);
        } else {
            ((JFXTimePicker)this.getWrappedObject()).setValue((Object)Instant.ofEpochMilli(time.getDate().getTime()).atZone(ZoneId.systemDefault()).toLocalTime());
        }
    }

    @Reflection.Getter
    public Color getDefaultColor() {
        return (Color)((JFXTimePicker)this.getWrappedObject()).getDefaultColor();
    }

    @Reflection.Setter
    public void setDefaultColor(@Reflection.Nullable Color color) {
        ((JFXTimePicker)this.getWrappedObject()).setDefaultColor((Paint)color);
    }

    @Reflection.Getter
    public boolean getHourView24() {
        return ((JFXTimePicker)this.getWrappedObject()).is24HourView();
    }

    @Reflection.Setter
    public void setHourView24(boolean value) {
        ((JFXTimePicker)this.getWrappedObject()).setIs24HourView(value);
    }

    protected Memory getValue(Environment env) {
        this.initFormat();
        if (((JFXTimePicker)this.getWrappedObject()).getConverter() == null) {
            return StringMemory.valueOf((String)((LocalTime)((JFXTimePicker)this.getWrappedObject()).getValue()).toString());
        }
        return StringMemory.valueOf((String)((JFXTimePicker)this.getWrappedObject()).getConverter().toString(((JFXTimePicker)this.getWrappedObject()).getValue()));
    }

    @Reflection.Signature
    protected void setValue(Environment env, Memory value) {
        this.initFormat();
        if (value.toString().isEmpty()) {
            ((JFXTimePicker)this.getWrappedObject()).setValue(null);
        } else {
            try {
                if (((JFXTimePicker)this.getWrappedObject()).getConverter() != null) {
                    ((JFXTimePicker)this.getWrappedObject()).setValue(((JFXTimePicker)this.getWrappedObject()).getConverter().fromString(value.toString()));
                } else {
                    ((JFXTimePicker)this.getWrappedObject()).setValue((Object)LocalTime.parse(value.toString()));
                }
            }
            catch (DateTimeParseException e) {
                ((JFXTimePicker)this.getWrappedObject()).setValue(null);
            }
        }
    }

    static class CustomConverter
    extends StringConverter<LocalTime> {
        private final DateTimeFormatter dateTimeFormatter;
        protected final String format;

        CustomConverter(String format) {
            this.format = format;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        }

        public String toString(LocalTime localDate) {
            if (localDate == null) {
                return "";
            }
            return this.dateTimeFormatter.format(localDate);
        }

        public LocalTime fromString(String dateString) {
            if (dateString == null || dateString.trim().isEmpty()) {
                return null;
            }
            return LocalTime.parse(dateString, this.dateTimeFormatter);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property(value="overlay")
        public boolean overLay();
    }
}

