/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessAssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IncExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import php.runtime.common.Association;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;

public class ASMExpression {
    protected Context context;
    protected Environment env;
    protected ExprStmtToken result;
    protected ExprStmtToken expr;
    protected Token prev;

    public ASMExpression(Environment env, Context context, ExprStmtToken expr) {
        OperatorExprToken operator;
        this.env = env;
        this.context = context;
        this.expr = expr;
        Stack<Token> stack = new Stack<Token>();
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 0;
        int size = expr.getTokens().size();
        Token next = null;
        for (Token token : expr.getTokens()) {
            Token token2 = next = i >= size - 1 ? null : expr.getTokens().get(i + 1);
            if (token instanceof OperatorExprToken) {
                OperatorExprToken operatorToken = (OperatorExprToken)token;
                if (operatorToken.isBinary()) {
                    if (next == null) {
                        this.unexpectedToken(operatorToken);
                    } else if (next instanceof OperatorExprToken && ((OperatorExprToken)next).isBinary()) {
                        this.unexpectedToken(next);
                    }
                }
                boolean isRight = this.prev == null;
                operator = null;
                if (this.prev instanceof OperatorExprToken) {
                    operator = (OperatorExprToken)this.prev;
                } else if (this.prev instanceof CallExprToken && ((CallExprToken)this.prev).getName() instanceof OperatorExprToken) {
                    operator = (OperatorExprToken)((CallExprToken)this.prev).getName();
                }
                if (operator != null) {
                    isRight = operator.getOnlyAssociation() != Association.LEFT;
                } else if (this.prev instanceof BraceExprToken) {
                    isRight = ((BraceExprToken)this.prev).isOpened();
                }
                if (isRight) {
                    ((OperatorExprToken)token).setAssociation(Association.RIGHT);
                } else {
                    ((OperatorExprToken)token).setAssociation(Association.LEFT);
                }
            }
            this.processToken(token, stack, result);
            this.prev = token instanceof ExprToken ? ((ExprToken)token).getLast() : token;
            ++i;
        }
        if (!stack.empty()) {
            this.processOperator(stack, result, null);
        }
        Stack<Token> checkStack = new Stack<Token>();
        i = 0;
        Token prev = null;
        for (Token el : result) {
            if (el instanceof OperatorExprToken) {
                operator = (OperatorExprToken)el;
                if (!operator.isValidAssociation()) {
                    this.unexpectedToken(operator);
                }
                if (el instanceof IncExprToken || el instanceof DecExprToken) {
                    OperatorExprToken newAssign;
                    if (prev != null && prev.getClass() == DynamicAccessExprToken.class) {
                        newAssign = new DynamicAccessAssignExprToken((DynamicAccessExprToken)prev);
                        newAssign.setAssignOperator(el);
                        result.set(i - 1, newAssign);
                        result.set(i, null);
                    } else if (prev != null && prev.getClass() == ArrayGetExprToken.class) {
                        newAssign = new ArrayGetRefExprToken((ArrayGetExprToken)prev);
                        result.set(i - 1, newAssign);
                    }
                }
                if (operator.isBinary()) {
                    if (checkStack.size() < 2) {
                        this.unexpectedToken(operator);
                    }
                    checkStack.pop();
                    checkStack.pop();
                    checkStack.push(null);
                } else {
                    if (checkStack.empty()) {
                        this.unexpectedToken(operator);
                    }
                    checkStack.pop();
                    checkStack.push(null);
                }
            } else if (el instanceof CallExprToken) {
                if (((CallExprToken)el).getName() instanceof OperatorExprToken) {
                    operator = (OperatorExprToken)((CallExprToken)el).getName();
                    if (operator.isBinary()) {
                        this.unexpectedToken(operator);
                    } else {
                        if (checkStack.empty()) {
                            this.unexpectedToken(operator);
                        }
                        checkStack.pop();
                        checkStack.push(null);
                    }
                } else {
                    checkStack.push(el);
                }
            } else {
                checkStack.push(el);
            }
            ++i;
            prev = el;
        }
        if (checkStack.size() > 1) {
            for (Token el : checkStack) {
                if (el == null) continue;
                this.unexpectedToken(el);
            }
        }
        this.result = new ExprStmtToken(null, null, result);
    }

    protected void processOperator(Stack<Token> stack, List<Token> result, OperatorExprToken current) {
        int prior;
        ArrayList<Token> list = new ArrayList<Token>();
        boolean isRightOperator = current != null && current.isRightSide();
        int n = prior = current == null ? -1 : current.getPriority();
        while (!stack.empty()) {
            boolean flush;
            Token el = stack.peek();
            int elPrior = this.getPriority(el);
            if (el instanceof BraceExprToken || current != null && current.getAssociation() == Association.RIGHT && !current.isBinary() && this.prev instanceof OperatorExprToken) break;
            boolean bl = current == null || elPrior == 1 || (isRightOperator ? elPrior > prior : elPrior <= prior) ? true : (flush = false);
            if (!flush) break;
            stack.pop();
            list.add(el);
        }
        result.addAll(list);
    }

    protected void processToken(Token token, Stack<Token> stack, List<Token> result) {
        if (token instanceof CallExprToken) {
            CallExprToken call = (CallExprToken)token;
            if (call.getName() instanceof OperatorExprToken) {
                this.processOperator(stack, result, (OperatorExprToken)call.getName());
            }
            result.add(token);
        } else if (token instanceof ValueExprToken) {
            result.add(token);
        } else if (token instanceof BraceExprToken) {
            BraceExprToken brace = (BraceExprToken)token;
            if (brace.isSimpleOpened()) {
                stack.push(brace);
            } else if (brace.isSimpleClosed()) {
                if (stack.empty()) {
                    this.unexpectedToken(brace);
                }
                boolean done = false;
                do {
                    Token el;
                    if ((el = stack.pop()) instanceof BraceExprToken && ((BraceExprToken)el).isSimpleOpened()) {
                        done = true;
                        break;
                    }
                    result.add(el);
                } while (!stack.isEmpty());
                if (!done) {
                    this.unexpectedToken(brace);
                }
            } else {
                this.unexpectedToken(brace);
            }
        } else if (token instanceof OperatorExprToken) {
            OperatorExprToken operator = (OperatorExprToken)token;
            this.processOperator(stack, result, operator);
            stack.push(token);
        }
    }

    public ExprStmtToken getResult() {
        return this.result;
    }

    private int getPriority(Token token) {
        if (token instanceof ExprToken) {
            return ((ExprToken)token).getPriority();
        }
        return 0;
    }

    protected void unexpectedToken(Token token) {
        this.env.error(token.toTraceInfo(this.context), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_X, new Object[]{token.getWord()});
    }
}

