/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.develnext.jphp.ext.javafx.classes.UXComboBoxBase;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXDatePicker")
public class UXDatePicker
extends UXComboBoxBase<DatePicker> {
    public UXDatePicker(Environment env, DatePicker wrappedObject) {
        super(env, wrappedObject);
    }

    public UXDatePicker(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new DatePicker();
    }

    private void initFormat() {
        if (((DatePicker)this.getWrappedObject()).getConverter() == null) {
            ((DatePicker)this.getWrappedObject()).setConverter((StringConverter)new CustomConverter("yyyy-MM-dd"));
        }
    }

    @Reflection.Setter
    public void setFormat(String value) {
        ((DatePicker)this.getWrappedObject()).setConverter((StringConverter)new CustomConverter(value));
    }

    @Reflection.Getter
    public String getFormat() {
        this.initFormat();
        StringConverter converter = ((DatePicker)this.getWrappedObject()).getConverter();
        if (converter instanceof CustomConverter) {
            return ((CustomConverter)converter).format;
        }
        return null;
    }

    @Reflection.Getter
    public WrapTime getValueAsTime(Environment env) {
        this.initFormat();
        LocalDate value = (LocalDate)((DatePicker)this.getWrappedObject()).getValue();
        if (value == null) {
            return null;
        }
        return new WrapTime(env, Date.from(value.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
    }

    @Reflection.Setter
    public void setValueAsTime(Environment env, @Reflection.Nullable WrapTime time) {
        this.initFormat();
        if (time == null) {
            ((DatePicker)this.getWrappedObject()).setValue(null);
        } else {
            ((DatePicker)this.getWrappedObject()).setValue((Object)Instant.ofEpochMilli(time.getDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
        }
    }

    @Override
    protected Memory getValue(Environment env) {
        this.initFormat();
        if (((DatePicker)this.getWrappedObject()).getConverter() == null) {
            return StringMemory.valueOf((String)((LocalDate)((DatePicker)this.getWrappedObject()).getValue()).toString());
        }
        return StringMemory.valueOf((String)((DatePicker)this.getWrappedObject()).getConverter().toString(((DatePicker)this.getWrappedObject()).getValue()));
    }

    @Override
    @Reflection.Signature
    protected void setValue(Environment env, Memory value) {
        this.initFormat();
        if (value.toString().isEmpty()) {
            ((DatePicker)this.getWrappedObject()).setValue(null);
        } else {
            try {
                if (((DatePicker)this.getWrappedObject()).getConverter() != null) {
                    ((DatePicker)this.getWrappedObject()).setValue(((DatePicker)this.getWrappedObject()).getConverter().fromString(value.toString()));
                } else {
                    ((DatePicker)this.getWrappedObject()).setValue((Object)LocalDate.parse(value.toString()));
                }
            }
            catch (DateTimeParseException e) {
                ((DatePicker)this.getWrappedObject()).setValue(null);
            }
        }
    }

    static class CustomConverter
    extends StringConverter<LocalDate> {
        private final DateTimeFormatter dateTimeFormatter;
        protected final String format;

        CustomConverter(String format) {
            this.format = format;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        }

        public String toString(LocalDate localDate) {
            if (localDate == null) {
                return "";
            }
            return this.dateTimeFormatter.format(localDate);
        }

        public LocalDate fromString(String dateString) {
            if (dateString == null || dateString.trim().isEmpty()) {
                return null;
            }
            return LocalDate.parse(dateString, this.dateTimeFormatter);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public TextField editor();

        @Reflection.Property
        public boolean showWeekNumbers();
    }
}

