/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.AbstractPipeline;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.FindOps;
import java.util.stream.ForEachOps;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.MatchOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.SliceOps;
import java.util.stream.SortedOps;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.Tripwire;

abstract class DoublePipeline<E_IN>
extends AbstractPipeline<E_IN, Double, DoubleStream>
implements DoubleStream {
    DoublePipeline(Supplier<? extends Spliterator<Double>> supplier, int n, boolean bl) {
        super(supplier, n, bl);
    }

    DoublePipeline(Spliterator<Double> spliterator, int n, boolean bl) {
        super(spliterator, n, bl);
    }

    DoublePipeline(AbstractPipeline<?, E_IN, ?> abstractPipeline, int n) {
        super(abstractPipeline, n);
    }

    private static DoubleConsumer adapt(Sink<Double> sink) {
        if (sink instanceof DoubleConsumer) {
            return (DoubleConsumer)((Object)sink);
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using DoubleStream.adapt(Sink<Double> s)");
        }
        return sink::accept;
    }

    private static Spliterator.OfDouble adapt(Spliterator<Double> spliterator) {
        if (spliterator instanceof Spliterator.OfDouble) {
            return (Spliterator.OfDouble)spliterator;
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using DoubleStream.adapt(Spliterator<Double> s)");
        }
        throw new UnsupportedOperationException("DoubleStream.adapt(Spliterator<Double> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.DOUBLE_VALUE;
    }

    @Override
    final <P_IN> Node<Double> evaluateToNode(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<Double[]> intFunction) {
        return Nodes.collectDouble(pipelineHelper, spliterator, bl);
    }

    @Override
    final <P_IN> Spliterator<Double> wrap(PipelineHelper<Double> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
        return new StreamSpliterators.DoubleWrappingSpliterator<P_IN>(pipelineHelper, supplier, bl);
    }

    final Spliterator.OfDouble lazySpliterator(Supplier<? extends Spliterator<Double>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfDouble((Supplier<Spliterator.OfDouble>)supplier);
    }

    @Override
    final void forEachWithCancel(Spliterator<Double> spliterator, Sink<Double> sink) {
        Spliterator.OfDouble ofDouble = DoublePipeline.adapt(spliterator);
        DoubleConsumer doubleConsumer = DoublePipeline.adapt(sink);
        while (!sink.cancellationRequested() && ofDouble.tryAdvance(doubleConsumer)) {
        }
    }

    @Override
    final Node.Builder<Double> makeNodeBuilder(long l, IntFunction<Double[]> intFunction) {
        return Nodes.doubleBuilder(l);
    }

    @Override
    public final PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfDouble spliterator() {
        return DoublePipeline.adapt(super.spliterator());
    }

    @Override
    public final Stream<Double> boxed() {
        return this.mapToObj(Double::valueOf);
    }

    @Override
    public final DoubleStream map(final DoubleUnaryOperator doubleUnaryOperator) {
        Objects.requireNonNull(doubleUnaryOperator);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void accept(double d) {
                        this.downstream.accept(doubleUnaryOperator.applyAsDouble(d));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(final DoubleFunction<? extends U> doubleFunction) {
        Objects.requireNonNull(doubleFunction);
        return new ReferencePipeline.StatelessOp<Double, U>(this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int n, Sink<U> sink) {
                return new Sink.ChainedDouble<U>(sink){

                    @Override
                    public void accept(double d) {
                        this.downstream.accept(doubleFunction.apply(d));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapToInt(final DoubleToIntFunction doubleToIntFunction) {
        Objects.requireNonNull(doubleToIntFunction);
        return new IntPipeline.StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedDouble<Integer>(sink){

                    @Override
                    public void accept(double d) {
                        this.downstream.accept(doubleToIntFunction.applyAsInt(d));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final DoubleToLongFunction doubleToLongFunction) {
        Objects.requireNonNull(doubleToLongFunction);
        return new LongPipeline.StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedDouble<Long>(sink){

                    @Override
                    public void accept(double d) {
                        this.downstream.accept(doubleToLongFunction.applyAsLong(d));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream flatMap(final DoubleFunction<? extends DoubleStream> doubleFunction) {
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(double d2) {
                        try (DoubleStream doubleStream = (DoubleStream)doubleFunction.apply(d2);){
                            if (doubleStream != null) {
                                doubleStream.sequential().forEach(d -> this.downstream.accept(d));
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public DoubleStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return sink;
            }
        };
    }

    @Override
    public final DoubleStream filter(final DoublePredicate doublePredicate) {
        Objects.requireNonNull(doublePredicate);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(double d) {
                        if (doublePredicate.test(d)) {
                            this.downstream.accept(d);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream peek(final DoubleConsumer doubleConsumer) {
        Objects.requireNonNull(doubleConsumer);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, 0){

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void accept(double d) {
                        doubleConsumer.accept(d);
                        this.downstream.accept(d);
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream limit(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        return SliceOps.makeDouble(this, 0L, l);
    }

    @Override
    public final DoubleStream skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        if (l == 0L) {
            return this;
        }
        long l2 = -1L;
        return SliceOps.makeDouble(this, l, l2);
    }

    @Override
    public final DoubleStream sorted() {
        return SortedOps.makeDouble(this);
    }

    @Override
    public final DoubleStream distinct() {
        return this.boxed().distinct().mapToDouble(d -> d);
    }

    @Override
    public void forEach(DoubleConsumer doubleConsumer) {
        this.evaluate(ForEachOps.makeDouble(doubleConsumer, false));
    }

    @Override
    public void forEachOrdered(DoubleConsumer doubleConsumer) {
        this.evaluate(ForEachOps.makeDouble(doubleConsumer, true));
    }

    @Override
    public final double sum() {
        double[] dArray3 = this.collect(() -> new double[3], (dArray, d) -> {
            Collectors.sumWithCompensation(dArray, d);
            dArray[2] = dArray[2] + d;
        }, (dArray, dArray2) -> {
            Collectors.sumWithCompensation(dArray, dArray2[0]);
            Collectors.sumWithCompensation(dArray, dArray2[1]);
            dArray[2] = dArray[2] + dArray2[2];
        });
        return Collectors.computeFinalSum(dArray3);
    }

    @Override
    public final OptionalDouble min() {
        return this.reduce(Math::min);
    }

    @Override
    public final OptionalDouble max() {
        return this.reduce(Math::max);
    }

    @Override
    public final OptionalDouble average() {
        double[] dArray3 = this.collect(() -> new double[4], (dArray, d) -> {
            dArray[2] = dArray[2] + 1.0;
            Collectors.sumWithCompensation(dArray, d);
            dArray[3] = dArray[3] + d;
        }, (dArray, dArray2) -> {
            Collectors.sumWithCompensation(dArray, dArray2[0]);
            Collectors.sumWithCompensation(dArray, dArray2[1]);
            dArray[2] = dArray[2] + dArray2[2];
            dArray[3] = dArray[3] + dArray2[3];
        });
        return dArray3[2] > 0.0 ? OptionalDouble.of(Collectors.computeFinalSum(dArray3) / dArray3[2]) : OptionalDouble.empty();
    }

    @Override
    public final long count() {
        return this.mapToLong(d -> 1L).sum();
    }

    @Override
    public final DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public final double reduce(double d, DoubleBinaryOperator doubleBinaryOperator) {
        return this.evaluate(ReduceOps.makeDouble(d, doubleBinaryOperator));
    }

    @Override
    public final OptionalDouble reduce(DoubleBinaryOperator doubleBinaryOperator) {
        return this.evaluate(ReduceOps.makeDouble(doubleBinaryOperator));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> objDoubleConsumer, BiConsumer<R, R> biConsumer) {
        BinaryOperator binaryOperator = (object, object2) -> {
            biConsumer.accept(object, object2);
            return object;
        };
        return this.evaluate(ReduceOps.makeDouble(supplier, objDoubleConsumer, binaryOperator));
    }

    @Override
    public final boolean anyMatch(DoublePredicate doublePredicate) {
        return this.evaluate(MatchOps.makeDouble(doublePredicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(DoublePredicate doublePredicate) {
        return this.evaluate(MatchOps.makeDouble(doublePredicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(DoublePredicate doublePredicate) {
        return this.evaluate(MatchOps.makeDouble(doublePredicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalDouble findFirst() {
        return this.evaluate(FindOps.makeDouble(true));
    }

    @Override
    public final OptionalDouble findAny() {
        return this.evaluate(FindOps.makeDouble(false));
    }

    @Override
    public final double[] toArray() {
        return (double[])Nodes.flattenDouble((Node.OfDouble)this.evaluateToArrayNode(Double[]::new)).asPrimitiveArray();
    }

    static abstract class StatefulOp<E_IN>
    extends DoublePipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> var1, Spliterator<P_IN> var2, IntFunction<Double[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends DoublePipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN>
    extends DoublePipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Double>> supplier, int n, boolean bl) {
            super(supplier, n, bl);
        }

        Head(Spliterator<Double> spliterator, int n, boolean bl) {
            super(spliterator, n, bl);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int n, Sink<Double> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            if (!this.isParallel()) {
                DoublePipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(doubleConsumer);
            } else {
                super.forEach(doubleConsumer);
            }
        }

        @Override
        public void forEachOrdered(DoubleConsumer doubleConsumer) {
            if (!this.isParallel()) {
                DoublePipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(doubleConsumer);
            } else {
                super.forEachOrdered(doubleConsumer);
            }
        }
    }
}

