/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderContainer$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderContainer$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderContainer$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$TabContentHolder$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$TabContentHolder$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$4;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$5;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$6;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.CachedTransition;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class JFXTabPaneSkin
extends BehaviorSkinBase<TabPane, TabPaneBehavior> {
    private final Color defaultColor = Color.valueOf((String)"#00BCD4");
    private final Color ripplerColor = Color.valueOf((String)"#FFFF8D");
    private final Color selectedTabText = Color.WHITE;
    private Color tempLabelColor = Color.WHITE;
    private HeaderContainer header;
    private ObservableList<TabContentHolder> tabContentHolders = FXCollections.observableArrayList();
    private Rectangle clip;
    private Rectangle tabsClip;
    private Tab selectedTab;
    private boolean isSelectingTab = false;
    private double dragStart;
    private double offsetStart;
    private AnchorPane tabsContainer;
    private AnchorPane tabsContainerHolder;
    private static final int SPACER = 10;
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private int diffTabsIndices = 0;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");

    public JFXTabPaneSkin(TabPane tabPane) {
        super((Control)tabPane, (BehaviorBase)new TabPaneBehavior(tabPane));
        this.header = new HeaderContainer();
        this.getChildren().add((Object)JFXDepthManager.createMaterialNode((Node)this.header, 1));
        this.tabsContainer = new AnchorPane();
        this.tabsContainerHolder = new AnchorPane();
        this.tabsContainerHolder.getChildren().add((Object)this.tabsContainer);
        this.tabsClip = new Rectangle();
        this.tabsContainerHolder.setClip((Node)this.tabsClip);
        this.getChildren().add((Object)this.tabsContainerHolder);
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContentHolder(tab);
        }
        this.clip = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((TabPane)this.getSkinnable()).setClip((Node)this.clip);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.header.setVisible(false);
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((TabPane)this.getSkinnable()).getSelectionModel().select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((TabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.header.headersRegion.setOnMouseDragged(JFXTabPaneSkin$$Lambda$1.lambdaFactory$(this));
        ((TabPane)this.getSkinnable()).setOnMousePressed(JFXTabPaneSkin$$Lambda$2.lambdaFactory$(this));
        ((TabPane)this.getSkinnable()).getTabs().addListener(JFXTabPaneSkin$$Lambda$3.lambdaFactory$(this));
        this.registerChangeListener((ObservableValue)tabPane.getSelectionModel().selectedItemProperty(), "SELECTED_TAB");
        this.registerChangeListener((ObservableValue)tabPane.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)tabPane.heightProperty(), "HEIGHT");
    }

    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("SELECTED_TAB".equals(property)) {
            this.isSelectingTab = true;
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            ((TabPane)this.getSkinnable()).requestLayout();
        } else if ("WIDTH".equals(property)) {
            this.clip.setWidth(((TabPane)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(property)) {
            this.clip.setHeight(((TabPane)this.getSkinnable()).getHeight());
        }
    }

    private void removeTabs(List<? extends Tab> removedTabs) {
        for (Tab tab : removedTabs) {
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.isClosing = true;
            this.removeTab(tab);
            if (!((TabPane)this.getSkinnable()).getTabs().isEmpty()) continue;
            this.header.setVisible(false);
        }
    }

    private void addTabs(List<? extends Tab> addedTabs, int startIndex) {
        int i = 0;
        for (Tab tab : addedTabs) {
            if (!this.header.isVisible()) {
                this.header.setVisible(true);
            }
            this.header.addTab(tab, startIndex + i++, false);
            this.addTabContentHolder(tab);
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.setVisible(true);
            tabHeaderContainer.inner.requestLayout();
        }
    }

    private void addTabContentHolder(Tab tab) {
        TabContentHolder tabContentHolder = new TabContentHolder(tab);
        tabContentHolder.setClip((Node)new Rectangle());
        this.tabContentHolders.add((Object)tabContentHolder);
        this.tabsContainer.getChildren().add(0, (Object)tabContentHolder);
    }

    private void removeTabContentHolder(Tab tab) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            if (!tabContentHolder.tab.equals(tab)) continue;
            tabContentHolder.removeListeners(tab);
            this.getChildren().remove((Object)tabContentHolder);
            this.tabContentHolders.remove((Object)tabContentHolder);
            this.tabsContainer.getChildren().remove((Object)tabContentHolder);
            break;
        }
    }

    private void removeTab(Tab tab) {
        TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
        if (tabHeaderContainer != null) {
            tabHeaderContainer.removeListeners(tab);
        }
        this.header.removeTab(tab);
        this.removeTabContentHolder(tab);
        this.header.requestLayout();
    }

    private boolean isHorizontal() {
        Side tabPosition = ((TabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)tabPosition) || Side.BOTTOM.equals((Object)tabPosition);
    }

    private static int getRotation(Side pos) {
        switch (pos) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxWidth = Math.max(this.maxWidth, this.snapSize(tabContentHolder.prefWidth(-1.0)));
        }
        double headerContainerWidth = this.snapSize(this.header.prefWidth(-1.0));
        double prefWidth = Math.max(this.maxWidth, headerContainerWidth);
        return this.snapSize(prefWidth) + rightInset + leftInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxHeight = Math.max(this.maxHeight, this.snapSize(tabContentHolder.prefHeight(-1.0)));
        }
        double headerContainerHeight = this.snapSize(this.header.prefHeight(-1.0));
        double prefHeight = this.maxHeight + this.snapSize(headerContainerHeight);
        return this.snapSize(prefHeight) + topInset + bottomInset;
    }

    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.header.getBaselineOffset() + topInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double headerHeight = this.snapSize(this.header.prefHeight(-1.0));
        Side side = ((TabPane)this.getSkinnable()).getSide();
        double tabsX = side == Side.RIGHT ? x + w - headerHeight : x;
        double tabsY = side == Side.BOTTOM ? y + h - headerHeight : y;
        int rotation = JFXTabPaneSkin.getRotation(side);
        switch (side) {
            case TOP: {
                this.header.resize(w, headerHeight);
                this.header.relocate(tabsX, tabsY);
                break;
            }
            case LEFT: {
                this.header.resize(h, headerHeight);
                this.header.relocate(tabsX + headerHeight, h - headerHeight);
                break;
            }
            case RIGHT: {
                this.header.resize(h, headerHeight);
                this.header.relocate(tabsX, y - headerHeight);
                break;
            }
            case BOTTOM: {
                this.header.resize(w, headerHeight);
                this.header.relocate(w, tabsY - headerHeight);
            }
        }
        this.header.getTransforms().setAll((Object[])new Transform[]{new Rotate((double)rotation, 0.0, headerHeight, 1.0)});
        double contentStartX = x + (side == Side.LEFT ? headerHeight : 0.0);
        double contentStartY = y + (side == Side.TOP ? headerHeight : 0.0);
        double contentWidth = w - (this.isHorizontal() ? 0.0 : headerHeight);
        double contentHeight = h - (this.isHorizontal() ? headerHeight : 0.0);
        this.tabsClip.setWidth(contentWidth);
        this.tabsClip.setHeight(contentHeight);
        this.tabsContainerHolder.resize(contentWidth, contentHeight);
        this.tabsContainerHolder.relocate(contentStartX, contentStartY);
        this.tabsContainer.resize(contentWidth * (double)this.tabContentHolders.size(), contentHeight);
        int max = this.tabContentHolders.size();
        for (int i = 0; i < max; ++i) {
            TabContentHolder tabContentHolder = (TabContentHolder)((Object)this.tabContentHolders.get(i));
            tabContentHolder.setVisible(true);
            tabContentHolder.setTranslateX(contentWidth * (double)i);
            if (tabContentHolder.getClip() != null) {
                ((Rectangle)tabContentHolder.getClip()).setWidth(contentWidth);
                ((Rectangle)tabContentHolder.getClip()).setHeight(contentHeight);
            }
            if (tabContentHolder.tab == this.selectedTab) {
                int index = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)this.selectedTab);
                if (index != i) {
                    this.tabsContainer.setTranslateX(-contentWidth * (double)i);
                    this.diffTabsIndices = i - index;
                } else {
                    if (this.diffTabsIndices != 0) {
                        this.tabsContainer.setTranslateX(this.tabsContainer.getTranslateX() + contentWidth * (double)this.diffTabsIndices);
                        this.diffTabsIndices = 0;
                    }
                    if (this.isSelectingTab && !((JFXTabPane)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                        new CachedTransition((Node)this.tabsContainer, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.tabsContainer.translateXProperty(), (Object)(-contentWidth * (double)index), Interpolator.EASE_BOTH)})})){
                            {
                                this.setCycleDuration(Duration.seconds((double)0.32));
                                this.setDelay(Duration.seconds((double)0.0));
                            }
                        }.play();
                    } else {
                        this.tabsContainer.setTranslateX(-contentWidth * (double)index);
                    }
                }
            }
            tabContentHolder.resize(contentWidth, contentHeight);
        }
    }

    static /* synthetic */ void lambda$new$2(JFXTabPaneSkin this_, ListChangeListener.Change change) {
        ArrayList tabsToBeRemoved = new ArrayList();
        ArrayList tabsToBeAdded = new ArrayList();
        int insertIndex = -1;
        while (change.next()) {
            if (change.wasPermutated()) {
                Tab selectedTab = (Tab)((TabPane)this_.getSkinnable()).getSelectionModel().getSelectedItem();
                ArrayList<Object> permutatedTabs = new ArrayList<Object>(change.getTo() - change.getFrom());
                ((TabPane)this_.getSkinnable()).getSelectionModel().clearSelection();
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    permutatedTabs.add(((TabPane)this_.getSkinnable()).getTabs().get(i));
                }
                this_.removeTabs(permutatedTabs);
                this_.addTabs(permutatedTabs, change.getFrom());
                ((TabPane)this_.getSkinnable()).getSelectionModel().select((Object)selectedTab);
            }
            if (change.wasRemoved()) {
                tabsToBeRemoved.addAll(change.getRemoved());
            }
            if (!change.wasAdded()) continue;
            tabsToBeAdded.addAll(change.getAddedSubList());
            insertIndex = change.getFrom();
        }
        tabsToBeRemoved.removeAll(tabsToBeAdded);
        this_.removeTabs(tabsToBeRemoved);
        if (!tabsToBeAdded.isEmpty()) {
            for (TabContentHolder tabContentHolder : this_.tabContentHolders) {
                TabHeaderContainer tabHeaderContainer = this_.header.getTabHeaderContainer(tabContentHolder.tab);
                if (tabHeaderContainer.isClosing || !tabsToBeAdded.contains(tabContentHolder.tab)) continue;
                tabsToBeAdded.remove(tabContentHolder.tab);
            }
            this_.addTabs(tabsToBeAdded, insertIndex == -1 ? this_.tabContentHolders.size() : insertIndex);
        }
        ((TabPane)this_.getSkinnable()).requestLayout();
    }

    static /* synthetic */ void lambda$new$1(JFXTabPaneSkin this_, MouseEvent me) {
        this_.dragStart = this_.isHorizontal() ? me.getSceneX() : me.getSceneY();
        this_.offsetStart = this_.header.scrollOffset;
    }

    static /* synthetic */ void lambda$new$0(JFXTabPaneSkin this_, MouseEvent me) {
        this_.header.updateScrollOffset(this_.offsetStart + (this_.isHorizontal() ? me.getSceneX() : me.getSceneY()) - this_.dragStart);
        me.consume();
    }

    protected class HeaderControl
    extends StackPane {
        private StackPane inner;
        private boolean showControlButtons;
        private boolean isLeftArrow;
        private Timeline arrowAnimation;
        private SVGGlyph arrowButton;
        private StackPane container;
        private SVGGlyph leftChevron = new SVGGlyph(0, "CHEVRON_LEFT", "M 742,-37 90,614 Q 53,651 53,704.5 53,758 90,795 l 652,651 q 37,37 90.5,37 53.5,0 90.5,-37 l 75,-75 q 37,-37 37,-90.5 0,-53.5 -37,-90.5 L 512,704 998,219 q 37,-38 37,-91 0,-53 -37,-90 L 923,-37 Q 886,-74 832.5,-74 779,-74 742,-37 z", (Paint)Color.WHITE);
        private SVGGlyph rightChevron = new SVGGlyph(0, "CHEVRON_RIGHT", "m 1099,704 q 0,-52 -37,-91 L 410,-38 q -37,-37 -90,-37 -53,0 -90,37 l -76,75 q -37,39 -37,91 0,53 37,90 l 486,486 -486,485 q -37,39 -37,91 0,53 37,90 l 76,75 q 36,38 90,38 54,0 90,-38 l 652,-651 q 37,-37 37,-90 z", (Paint)Color.WHITE);
        private boolean showTabsHeaderControls = false;

        public HeaderControl(ArrowPosition pos) {
            this.getStyleClass().setAll((Object[])new String[]{"control-buttons-tab"});
            this.isLeftArrow = pos == ArrowPosition.LEFT;
            this.arrowButton = this.isLeftArrow ? this.leftChevron : this.rightChevron;
            this.arrowButton.setStyle("-fx-min-width:0.8em;-fx-max-width:0.8em;-fx-min-height:1.3em;-fx-max-height:1.3em;");
            this.arrowButton.getStyleClass().setAll((Object[])new String[]{"tab-down-button"});
            this.arrowButton.setVisible(this.isControlButtonShown());
            this.arrowButton.setFill((Paint)JFXTabPaneSkin.this.selectedTabText);
            StackPane.setMargin((Node)this.arrowButton, (Insets)new Insets(0.0, 0.0, 0.0, this.isLeftArrow ? -4.0 : 4.0));
            SimpleDoubleProperty offsetProperty = new SimpleDoubleProperty(0.0);
            offsetProperty.addListener(JFXTabPaneSkin$HeaderControl$$Lambda$1.lambdaFactory$(this));
            this.container = new StackPane(new Node[]{this.arrowButton});
            this.container.getStyleClass().add((Object)"container");
            this.container.setPadding(new Insets(7.0));
            this.container.setCursor(Cursor.HAND);
            this.container.setOnMousePressed(JFXTabPaneSkin$HeaderControl$$Lambda$2.lambdaFactory$(this, (DoubleProperty)offsetProperty));
            this.container.setOnMouseReleased(JFXTabPaneSkin$HeaderControl$$Lambda$3.lambdaFactory$(this));
            final JFXRippler arrowRippler = new JFXRippler((Node)this.container, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
            arrowRippler.ripplerFillProperty().bind(this.arrowButton.fillProperty());
            arrowRippler.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            this.inner = new StackPane(){

                protected double computePrefWidth(double height) {
                    double preferWidth = 0.0;
                    double maxArrowWidth = !HeaderControl.this.isControlButtonShown() ? 0.0 : this.snapSize(arrowRippler.prefWidth(this.getHeight()));
                    return preferWidth += (preferWidth += HeaderControl.this.isControlButtonShown() ? maxArrowWidth : 0.0) > 0.0 ? this.snappedLeftInset() + this.snappedRightInset() : 0.0;
                }

                protected double computePrefHeight(double width) {
                    double prefHeight = 0.0;
                    prefHeight = HeaderControl.this.isControlButtonShown() ? Math.max(prefHeight, this.snapSize(arrowRippler.prefHeight(width))) : 0.0;
                    return prefHeight += prefHeight > 0.0 ? this.snappedTopInset() + this.snappedBottomInset() : 0.0;
                }

                protected void layoutChildren() {
                    if (HeaderControl.this.isControlButtonShown()) {
                        double x = 0.0;
                        double y = this.snappedTopInset();
                        double width = this.snapSize(this.getWidth()) - x + this.snappedLeftInset();
                        double height = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
                        this.positionArrow(arrowRippler, x, y, width, height);
                    }
                }

                private void positionArrow(JFXRippler rippler, double x, double y, double width, double height) {
                    rippler.resize(width, height);
                    this.positionInArea((Node)rippler, x, y, width, height, 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            this.inner.getChildren().add((Object)arrowRippler);
            this.getChildren().add((Object)this.inner);
            this.showControlButtons = false;
            if (this.isControlButtonShown()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
        }

        private void showTabsMenu(boolean value) {
            boolean wasTabsMenuShowing = this.isControlButtonShown();
            this.showTabsHeaderControls = value;
            if (this.showTabsHeaderControls && !wasTabsMenuShowing) {
                this.arrowButton.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                JFXTabPaneSkin.this.header.layoutChildren();
            } else if (!this.showTabsHeaderControls && wasTabsMenuShowing) {
                this.container.setPrefWidth(0.0);
                if (this.isControlButtonShown()) {
                    this.showControlButtons = true;
                } else {
                    this.setVisible(false);
                }
                this.requestLayout();
            }
        }

        private boolean isControlButtonShown() {
            return this.showTabsHeaderControls;
        }

        protected double computePrefWidth(double height) {
            double prefWidth = this.snapSize(this.inner.prefWidth(height));
            if (prefWidth > 0.0) {
                prefWidth += this.snappedLeftInset() + this.snappedRightInset();
            }
            return prefWidth;
        }

        protected double computePrefHeight(double width) {
            return Math.max(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight(), this.snapSize(this.inner.prefHeight(width))) + this.snappedTopInset() + this.snappedBottomInset();
        }

        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double width = this.snapSize(this.getWidth()) - x + this.snappedRightInset();
            double height = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
            if (this.showControlButtons) {
                this.setVisible(true);
                this.showControlButtons = false;
            }
            this.inner.resize(width, height);
            this.positionInArea((Node)this.inner, x, y, width, height, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        static /* synthetic */ void lambda$new$2(HeaderControl this_, MouseEvent release) {
            this_.arrowAnimation.stop();
        }

        static /* synthetic */ void lambda$new$1(HeaderControl this_, DoubleProperty offsetProperty, MouseEvent press) {
            offsetProperty.set(this_.JFXTabPaneSkin.this.header.scrollOffset);
            double offset = this_.isLeftArrow ? this_.JFXTabPaneSkin.this.header.scrollOffset + this_.JFXTabPaneSkin.this.header.headersRegion.getWidth() : this_.JFXTabPaneSkin.this.header.scrollOffset - this_.JFXTabPaneSkin.this.header.headersRegion.getWidth();
            this_.arrowAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)offsetProperty, (Object)offset, Interpolator.LINEAR)})});
            this_.arrowAnimation.play();
        }

        static /* synthetic */ void lambda$new$0(HeaderControl this_, ObservableValue o, Number oldVal, Number newVal) {
            this_.JFXTabPaneSkin.this.header.updateScrollOffset(newVal.doubleValue());
        }
    }

    private static enum ArrowPosition {
        RIGHT,
        LEFT;

    }

    protected class TabContentHolder
    extends StackPane {
        private Tab tab;
        private InvalidationListener tabContentListener = JFXTabPaneSkin$TabContentHolder$$Lambda$1.lambdaFactory$(this);
        private InvalidationListener tabSelectedListener = JFXTabPaneSkin$TabContentHolder$$Lambda$2.lambdaFactory$(this);
        private WeakInvalidationListener weakTabContentListener = new WeakInvalidationListener(this.tabContentListener);
        private WeakInvalidationListener weakTabSelectedListener = new WeakInvalidationListener(this.tabSelectedListener);

        public TabContentHolder(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Object[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.updateContent();
            this.setVisible(tab.isSelected());
            tab.selectedProperty().addListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().addListener((InvalidationListener)this.weakTabContentListener);
        }

        private void updateContent() {
            Node newContent = this.tab.getContent();
            if (newContent == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{newContent});
            }
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().removeListener((InvalidationListener)this.weakTabContentListener);
        }

        static /* synthetic */ void lambda$new$1(TabContentHolder this_, Observable valueModel) {
            this_.setVisible(this_.tab.isSelected());
        }

        static /* synthetic */ void lambda$new$0(TabContentHolder this_, Observable valueModel) {
            this_.updateContent();
        }
    }

    protected class TabHeaderContainer
    extends StackPane {
        private Tab tab = null;
        private Label tabText;
        private Tooltip oldTooltip;
        private Tooltip tooltip;
        private BorderPane inner;
        private JFXRippler rippler;
        private boolean systemChange = false;
        private boolean isClosing = false;
        private final MultiplePropertyChangeListenerHandler listener = new MultiplePropertyChangeListenerHandler(JFXTabPaneSkin$TabHeaderContainer$$Lambda$1.lambdaFactory$(this));
        private final ListChangeListener<String> styleClassListener = JFXTabPaneSkin$TabHeaderContainer$$Lambda$2.lambdaFactory$(this);
        private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener(this.styleClassListener);

        public TabHeaderContainer(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Collection)tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.tabText = new Label(tab.getText(), tab.getGraphic());
            this.tabText.setFont(Font.font((String)"", (FontWeight)FontWeight.BOLD, (double)16.0));
            this.tabText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
            this.tabText.getStyleClass().setAll((Object[])new String[]{"tab-label"});
            this.inner = new BorderPane();
            this.inner.setCenter((Node)this.tabText);
            this.inner.getStyleClass().add((Object)"tab-container");
            this.inner.setRotate(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.rippler = new JFXRippler((Node)this.inner, JFXRippler.RipplerPos.FRONT);
            this.rippler.setRipplerFill((Paint)JFXTabPaneSkin.this.ripplerColor);
            this.getChildren().addAll((Object[])new Node[]{this.rippler});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install((Node)this, (Tooltip)this.tooltip);
                this.oldTooltip = this.tooltip;
            }
            if (tab.isSelected()) {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.selectedTabText);
            } else {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.tempLabelColor.deriveColor(0.0, 0.0, 0.9, 1.0));
            }
            this.tabText.textFillProperty().addListener(JFXTabPaneSkin$TabHeaderContainer$$Lambda$3.lambdaFactory$(this));
            tab.selectedProperty().addListener(JFXTabPaneSkin$TabHeaderContainer$$Lambda$4.lambdaFactory$(this));
            this.listener.registerChangeListener((ObservableValue)tab.selectedProperty(), "SELECTED");
            this.listener.registerChangeListener((ObservableValue)tab.textProperty(), "TEXT");
            this.listener.registerChangeListener((ObservableValue)tab.graphicProperty(), "GRAPHIC");
            this.listener.registerChangeListener((ObservableValue)tab.tooltipProperty(), "TOOLTIP");
            this.listener.registerChangeListener((ObservableValue)tab.disableProperty(), "DISABLE");
            this.listener.registerChangeListener((ObservableValue)tab.styleProperty(), "STYLE");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinWidthProperty(), "TAB_MIN_WIDTH");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxWidthProperty(), "TAB_MAX_WIDTH");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinHeightProperty(), "TAB_MIN_HEIGHT");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxHeightProperty(), "TAB_MAX_HEIGHT");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).sideProperty(), "SIDE");
            tab.getStyleClass().addListener(this.weakStyleClassListener);
            this.getProperties().put(Tab.class, (Object)tab);
            this.setOnMouseClicked(JFXTabPaneSkin$TabHeaderContainer$$Lambda$5.lambdaFactory$(this, tab));
            this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, JFXTabPaneSkin$TabHeaderContainer$$Lambda$6.lambdaFactory$(this, tab));
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisable());
            Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
            this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
            this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
            this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
        }

        private void handlePropertyChanged(String p) {
            if ("SELECTED".equals(p)) {
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.tab.isSelected());
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("TEXT".equals(p)) {
                this.tabText.setText(this.tab.getText());
            } else if ("GRAPHIC".equals(p)) {
                this.tabText.setGraphic(this.tab.getGraphic());
            } else if ("TOOLTIP".equals(p)) {
                if (this.oldTooltip != null) {
                    Tooltip.uninstall((Node)this, (Tooltip)this.oldTooltip);
                }
                this.tooltip = this.tab.getTooltip();
                if (this.tooltip != null) {
                    Tooltip.install((Node)this, (Tooltip)this.tooltip);
                    this.oldTooltip = this.tooltip;
                }
            } else if ("DISABLE".equals(p)) {
                this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.tab.isDisable());
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("STYLE".equals(p)) {
                this.setStyle(this.tab.getStyle());
            } else if ("TAB_MIN_WIDTH".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MAX_WIDTH".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MIN_HEIGHT".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MAX_HEIGHT".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("SIDE".equals(p)) {
                Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
                this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
                this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
                this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
                this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
                this.inner.setRotate(side == Side.BOTTOM ? 180.0 : 0.0);
            }
        }

        private void removeListeners(Tab tab) {
            this.listener.dispose();
            this.inner.getChildren().clear();
            this.getChildren().clear();
        }

        protected double computePrefWidth(double height) {
            double minWidth = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinWidth());
            double maxWidth = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxWidth());
            double paddingRight = this.snappedRightInset();
            double paddingLeft = this.snappedLeftInset();
            double tmpPrefWidth = this.snapSize(this.tabText.prefWidth(-1.0));
            if (tmpPrefWidth > maxWidth) {
                tmpPrefWidth = maxWidth;
            } else if (tmpPrefWidth < minWidth) {
                tmpPrefWidth = minWidth;
            }
            return tmpPrefWidth += paddingRight + paddingLeft;
        }

        protected double computePrefHeight(double width) {
            double minHeight = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight());
            double maxHeight = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxHeight());
            double paddingTop = this.snappedTopInset();
            double paddingBottom = this.snappedBottomInset();
            double tmpPrefHeight = this.snapSize(this.tabText.prefHeight(width));
            if (tmpPrefHeight > maxHeight) {
                tmpPrefHeight = maxHeight;
            } else if (tmpPrefHeight < minHeight) {
                tmpPrefHeight = minHeight;
            }
            return tmpPrefHeight += paddingTop + paddingBottom;
        }

        protected void layoutChildren() {
            double w = this.snapSize(this.getWidth()) - this.snappedRightInset() - this.snappedLeftInset();
            this.rippler.resize(w, this.snapSize(this.getHeight()) - this.snappedTopInset() - this.snappedBottomInset());
            this.rippler.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }

        protected void setWidth(double value) {
            super.setWidth(value);
        }

        protected void setHeight(double value) {
            super.setHeight(value);
        }

        static /* synthetic */ void lambda$new$5(TabHeaderContainer this_, Tab tab, ContextMenuEvent event) {
            ContextMenu contextMenu = tab.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show((Node)this_.tabText, event.getScreenX(), event.getScreenY());
                event.consume();
            }
        }

        static /* synthetic */ void lambda$new$4(TabHeaderContainer this_, Tab tab, MouseEvent event) {
            if (tab.isDisable() || !event.isStillSincePress()) {
                return;
            }
            if (event.getButton() == MouseButton.PRIMARY) {
                this_.setOpacity(1.0);
                ((TabPaneBehavior)this_.JFXTabPaneSkin.this.getBehavior()).selectTab(tab);
            }
        }

        static /* synthetic */ void lambda$new$3(TabHeaderContainer this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
            this_.systemChange = true;
            if (newVal.booleanValue()) {
                this_.tabText.setTextFill((Paint)this_.JFXTabPaneSkin.this.tempLabelColor);
            } else {
                this_.tabText.setTextFill((Paint)this_.JFXTabPaneSkin.this.tempLabelColor.deriveColor(0.0, 0.0, 0.9, 1.0));
            }
            this_.systemChange = false;
        }

        static /* synthetic */ void lambda$new$2(TabHeaderContainer this_, ObservableValue o, Paint oldVal, Paint newVal) {
            if (!this_.systemChange) {
                this_.JFXTabPaneSkin.this.tempLabelColor = (Color)newVal;
            }
        }

        static /* synthetic */ void lambda$new$1(TabHeaderContainer this_, ListChangeListener.Change change) {
            this_.getStyleClass().setAll((Collection)this_.tab.getStyleClass());
        }

        static /* synthetic */ Void lambda$new$0(TabHeaderContainer this_, String param) {
            this_.handlePropertyChanged(param);
            return null;
        }
    }

    protected class HeaderContainer
    extends StackPane {
        private Rectangle clip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private HeaderControl rightControlButton;
        private HeaderControl leftControlButton;
        private StackPane selectedTabLine;
        private boolean initialized = false;
        private boolean measureClosingTabs = false;
        private double scrollOffset;
        private double selectedTabLineOffset;
        private final Scale scale;
        private final Rotate rotate;
        private int direction;
        private Timeline timeline;
        private final double translateScaleFactor = 1.3;
        private List<TabHeaderContainer> removedTabsHeaders = new ArrayList<TabHeaderContainer>();

        public HeaderContainer() {
            ((TabPane)JFXTabPaneSkin.this.getSkinnable()).sideProperty().addListener(JFXTabPaneSkin$HeaderContainer$$Lambda$1.lambdaFactory$(this));
            this.updateDirection();
            this.getStyleClass().setAll((Object[])new String[]{"tab-header-area"});
            this.setManaged(false);
            this.clip = new Rectangle();
            this.headersRegion = new StackPane(){

                protected double computePrefWidth(double height) {
                    double width = 0.0;
                    for (Node child : this.getChildren()) {
                        if (!(child instanceof TabHeaderContainer) || !child.isVisible() || !HeaderContainer.this.measureClosingTabs && ((TabHeaderContainer)child).isClosing) continue;
                        width += child.prefWidth(height);
                    }
                    return this.snapSize(width) + this.snappedLeftInset() + this.snappedRightInset();
                }

                protected double computePrefHeight(double width) {
                    double height = 0.0;
                    for (Node child : this.getChildren()) {
                        if (!(child instanceof TabHeaderContainer)) continue;
                        height = Math.max(height, child.prefHeight(width));
                    }
                    return this.snapSize(height) + this.snappedTopInset() + this.snappedBottomInset();
                }

                protected void layoutChildren() {
                    if (HeaderContainer.this.isTabsFitHeaderWidth()) {
                        HeaderContainer.this.updateScrollOffset(0.0);
                    } else if (!HeaderContainer.this.removedTabsHeaders.isEmpty()) {
                        double offset = 0.0;
                        double w = JFXTabPaneSkin.this.header.getWidth() - this.snapSize(HeaderContainer.this.rightControlButton.prefWidth(-1.0)) - this.snapSize(HeaderContainer.this.leftControlButton.prefWidth(-1.0)) - this.snappedLeftInset() - 10.0;
                        Iterator itr = this.getChildren().iterator();
                        while (itr.hasNext()) {
                            Node temp = (Node)itr.next();
                            if (!(temp instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer tabHeaderContainer = (TabHeaderContainer)temp;
                            double containerPrefWidth = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                            if (HeaderContainer.this.removedTabsHeaders.contains((Object)tabHeaderContainer)) {
                                if (offset < w) {
                                    JFXTabPaneSkin.this.isSelectingTab = true;
                                }
                                itr.remove();
                                HeaderContainer.this.removedTabsHeaders.remove((Object)tabHeaderContainer);
                                if (HeaderContainer.this.removedTabsHeaders.isEmpty()) break;
                            }
                            offset += containerPrefWidth;
                        }
                    }
                    if (JFXTabPaneSkin.this.isSelectingTab) {
                        HeaderContainer.this.animateSelectionLine();
                        JFXTabPaneSkin.this.isSelectingTab = false;
                    } else {
                        HeaderContainer.this.updateScrollOffset(HeaderContainer.this.scrollOffset);
                    }
                    double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
                    Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
                    double tabStartX = side == Side.LEFT || side == Side.BOTTOM ? this.snapSize(this.getWidth()) - HeaderContainer.this.scrollOffset : HeaderContainer.this.scrollOffset;
                    HeaderContainer.this.updateHeaderContainerClip();
                    for (Node node : this.getChildren()) {
                        double tabStartY;
                        if (!(node instanceof TabHeaderContainer)) continue;
                        TabHeaderContainer tabHeaderContainer = (TabHeaderContainer)node;
                        double tabHeaderPrefWidth = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                        double tabHeaderPrefHeight = this.snapSize(tabHeaderContainer.prefHeight(-1.0));
                        tabHeaderContainer.resize(tabHeaderPrefWidth, tabHeaderPrefHeight);
                        double d = tabStartY = side == Side.BOTTOM ? 0.0 : tabBackgroundHeight - tabHeaderPrefHeight - this.snappedBottomInset();
                        if (side == Side.LEFT || side == Side.BOTTOM) {
                            tabHeaderContainer.relocate(tabStartX -= tabHeaderPrefWidth, tabStartY);
                            continue;
                        }
                        tabHeaderContainer.relocate(tabStartX, tabStartY);
                        tabStartX += tabHeaderPrefWidth;
                    }
                    HeaderContainer.this.selectedTabLine.resizeRelocate(side == Side.LEFT || side == Side.BOTTOM ? this.snapSize(HeaderContainer.this.headersRegion.getWidth()) : 0.0, tabBackgroundHeight - HeaderContainer.this.selectedTabLine.prefHeight(-1.0), this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                }
            };
            this.headersRegion.getStyleClass().setAll((Object[])new String[]{"headers-region"});
            this.headersRegion.setCache(true);
            this.headersRegion.setClip((Node)this.clip);
            this.headerBackground = new StackPane();
            this.headerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)JFXTabPaneSkin.this.defaultColor, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.headerBackground.getStyleClass().setAll((Object[])new String[]{"tab-header-background"});
            this.selectedTabLine = new StackPane();
            this.scale = new Scale(1.0, 1.0, 0.0, 0.0);
            this.rotate = new Rotate(0.0, 0.0, 1.0);
            this.rotate.pivotYProperty().bind((ObservableValue)this.selectedTabLine.heightProperty().divide(2));
            this.selectedTabLine.getTransforms().addAll((Object[])new Transform[]{this.scale, this.rotate});
            this.selectedTabLine.setCache(true);
            this.selectedTabLine.getStyleClass().add((Object)"tab-selected-line");
            this.selectedTabLine.setPrefHeight(2.0);
            this.selectedTabLine.setPrefWidth(1.0);
            this.selectedTabLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)JFXTabPaneSkin.this.ripplerColor, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.headersRegion.getChildren().add((Object)this.selectedTabLine);
            this.rightControlButton = new HeaderControl(ArrowPosition.RIGHT);
            this.leftControlButton = new HeaderControl(ArrowPosition.LEFT);
            this.rightControlButton.setVisible(false);
            this.leftControlButton.setVisible(false);
            this.rightControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.leftControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.getChildren().addAll((Object[])new Node[]{this.headerBackground, this.headersRegion, this.leftControlButton, this.rightControlButton});
            int i = 0;
            for (Tab tab : ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabs()) {
                this.addTab(tab, i++, true);
            }
            this.addEventHandler(ScrollEvent.SCROLL, JFXTabPaneSkin$HeaderContainer$$Lambda$2.lambdaFactory$(this));
        }

        private void updateDirection() {
            Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            this.direction = side == Side.BOTTOM || side == Side.LEFT ? -1 : 1;
        }

        private void updateHeaderContainerClip() {
            double clipOffset = this.getClipOffset();
            Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            double controlPrefWidth = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0));
            this.measureClosingTabs = true;
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.measureClosingTabs = false;
            double maxWidth = this.snapSize(this.getWidth()) - controlPrefWidth - clipOffset;
            double clipWidth = headersPrefWidth < maxWidth ? headersPrefWidth : maxWidth;
            double clipHeight = headersPrefHeight;
            this.clip.setX((side == Side.LEFT || side == Side.BOTTOM) && headersPrefWidth >= maxWidth ? headersPrefWidth - maxWidth : 0.0);
            this.clip.setY(0.0);
            this.clip.setWidth(clipWidth);
            this.clip.setHeight(clipHeight);
        }

        private double getClipOffset() {
            return JFXTabPaneSkin.this.isHorizontal() ? this.snappedLeftInset() : this.snappedRightInset();
        }

        private void addTab(Tab tab, int addToIndex, boolean visible) {
            TabHeaderContainer tabHeaderContainer = new TabHeaderContainer(tab);
            tabHeaderContainer.setVisible(visible);
            this.headersRegion.getChildren().add(addToIndex, (Object)tabHeaderContainer);
        }

        private void removeTab(Tab tab) {
            TabHeaderContainer tabHeaderContainer = this.getTabHeaderContainer(tab);
            if (tabHeaderContainer != null) {
                if (this.isTabsFitHeaderWidth()) {
                    this.headersRegion.getChildren().remove((Object)tabHeaderContainer);
                } else {
                    this.removedTabsHeaders.add(tabHeaderContainer);
                    tabHeaderContainer.removeListeners(tab);
                }
            }
        }

        private TabHeaderContainer getTabHeaderContainer(Tab tab) {
            for (Node child : this.headersRegion.getChildren()) {
                if (!(child instanceof TabHeaderContainer) || !((TabHeaderContainer)child).tab.equals(tab)) continue;
                return (TabHeaderContainer)child;
            }
            return null;
        }

        private boolean isTabsFitHeaderWidth() {
            double rightControlWidth;
            double headerPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double visibleWidth = headerPrefWidth + (rightControlWidth = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0))) + this.snappedLeftInset() + 10.0;
            return visibleWidth < this.getWidth();
        }

        private void runTimeline(double newTransX, double newWidth) {
            double midScaleX;
            double tempScaleX = 0.0;
            double tempWidth = 0.0;
            double lineWidth = this.selectedTabLine.prefWidth(-1.0);
            if (this.isAnimating()) {
                this.timeline.stop();
                tempScaleX = this.scale.getX();
                if (this.rotate.getAngle() != 0.0) {
                    this.rotate.setAngle(0.0);
                    tempWidth = tempScaleX * lineWidth;
                    this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() - tempWidth);
                }
            }
            double oldScaleX = this.scale.getX();
            double oldWidth = lineWidth * oldScaleX;
            double oldTransX = this.selectedTabLine.getTranslateX();
            double newScaleX = newWidth * oldScaleX / oldWidth;
            this.selectedTabLineOffset = newTransX;
            double transDiff = (newTransX += JFXTabPaneSkin.this.offsetStart * (double)this.direction) - oldTransX;
            double d = midScaleX = tempScaleX != 0.0 ? tempScaleX : (Math.abs(transDiff) / 1.3 + oldWidth) * oldScaleX / oldWidth;
            if (transDiff < 0.0) {
                this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() + oldWidth);
                newTransX += newWidth;
                this.rotate.setAngle(180.0);
            }
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.12), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)midScaleX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.24), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)newScaleX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)newTransX, Interpolator.EASE_BOTH)})});
            this.timeline.setOnFinished(JFXTabPaneSkin$HeaderContainer$$Lambda$3.lambdaFactory$(this, newWidth));
            this.timeline.play();
        }

        private boolean isAnimating() {
            return this.timeline != null && this.timeline.getStatus() == Animation.Status.RUNNING;
        }

        public void updateScrollOffset(double newOffset) {
            double tabPaneWidth = this.snapSize(JFXTabPaneSkin.this.isHorizontal() ? ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getWidth() : ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getHeight());
            double controlTabWidth = 2.0 * this.snapSize(this.rightControlButton.getWidth());
            double visibleWidth = tabPaneWidth - controlTabWidth - this.snappedLeftInset() - 10.0;
            double offset = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer)) continue;
                double tabHeaderPrefWidth = this.snapSize(node.prefWidth(-1.0));
                offset += tabHeaderPrefWidth;
            }
            double actualOffset = newOffset;
            if (visibleWidth - newOffset > offset && newOffset < 0.0) {
                actualOffset = visibleWidth - offset;
            } else if (newOffset > 0.0) {
                actualOffset = 0.0;
            }
            if (actualOffset != this.scrollOffset) {
                this.scrollOffset = actualOffset;
                this.headersRegion.requestLayout();
                if (!this.isAnimating()) {
                    this.selectedTabLine.setTranslateX(this.selectedTabLineOffset + this.scrollOffset * (double)this.direction);
                }
            }
        }

        protected double computePrefWidth(double height) {
            double padding = JFXTabPaneSkin.this.isHorizontal() ? 2.0 * this.snappedLeftInset() + this.snappedRightInset() : 2.0 * this.snappedTopInset() + this.snappedBottomInset();
            return this.snapSize(this.headersRegion.prefWidth(height)) + 2.0 * this.rightControlButton.prefWidth(height) + padding + 10.0;
        }

        protected double computePrefHeight(double width) {
            double padding = JFXTabPaneSkin.this.isHorizontal() ? this.snappedTopInset() + this.snappedBottomInset() : this.snappedLeftInset() + this.snappedRightInset();
            return this.snapSize(this.headersRegion.prefHeight(-1.0)) + padding;
        }

        public double getBaselineOffset() {
            return ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide() == Side.TOP ? this.headersRegion.getBaselineOffset() + this.snappedTopInset() : 0.0;
        }

        protected void layoutChildren() {
            double leftInset = this.snappedLeftInset();
            double rightInset = this.snappedRightInset();
            double topInset = this.snappedTopInset();
            double bottomInset = this.snappedBottomInset();
            double padding = JFXTabPaneSkin.this.isHorizontal() ? leftInset + rightInset : topInset + bottomInset;
            double w = this.snapSize(this.getWidth()) - padding;
            double h = this.snapSize(this.getHeight()) - padding;
            double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.rightControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.leftControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.updateHeaderContainerClip();
            this.headersRegion.requestLayout();
            double btnWidth = this.snapSize(this.rightControlButton.prefWidth(-1.0));
            double btnHeight = this.rightControlButton.prefHeight(btnWidth);
            this.rightControlButton.resize(btnWidth, btnHeight);
            this.leftControlButton.resize(btnWidth, btnHeight);
            this.headersRegion.resize(headersPrefWidth, headersPrefHeight);
            this.headerBackground.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
            Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            double startX = 0.0;
            double startY = 0.0;
            double controlStartX = 0.0;
            double controlStartY = 0.0;
            switch (side) {
                case TOP: {
                    startX = leftInset;
                    startY = tabBackgroundHeight - headersPrefHeight - bottomInset;
                    controlStartX = w - btnWidth + leftInset;
                    controlStartY = this.snapSize(this.getHeight()) - btnHeight - bottomInset;
                    break;
                }
                case BOTTOM: {
                    startX = this.snapSize(this.getWidth()) - headersPrefWidth - leftInset;
                    startY = tabBackgroundHeight - headersPrefHeight - topInset;
                    controlStartX = rightInset;
                    controlStartY = this.snapSize(this.getHeight()) - btnHeight - topInset;
                    break;
                }
                case LEFT: {
                    startX = this.snapSize(this.getWidth()) - headersPrefWidth - topInset;
                    startY = tabBackgroundHeight - headersPrefHeight - rightInset;
                    controlStartX = leftInset;
                    controlStartY = this.snapSize(this.getHeight()) - btnHeight - rightInset;
                    break;
                }
                case RIGHT: {
                    startX = topInset;
                    startY = tabBackgroundHeight - headersPrefHeight - leftInset;
                    controlStartX = w - btnWidth + topInset;
                    controlStartY = this.snapSize(this.getHeight()) - btnHeight - leftInset;
                }
            }
            if (this.headerBackground.isVisible()) {
                this.positionInArea((Node)this.headerBackground, 0.0, 0.0, this.snapSize(this.getWidth()), this.snapSize(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea((Node)this.headersRegion, startX + btnWidth * (double)(side == Side.LEFT || side == Side.BOTTOM ? -1 : 1), startY, w, h, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea((Node)this.rightControlButton, controlStartX, controlStartY, btnWidth, btnHeight, 0.0, HPos.CENTER, VPos.CENTER);
            this.positionInArea((Node)this.leftControlButton, side == Side.LEFT || side == Side.BOTTOM ? w - btnWidth : 0.0, controlStartY, btnWidth, btnHeight, 0.0, HPos.CENTER, VPos.CENTER);
            this.rightControlButton.setRotate(side == Side.LEFT || side == Side.BOTTOM ? 180.0 : 0.0);
            this.leftControlButton.setRotate(side == Side.LEFT || side == Side.BOTTOM ? 180.0 : 0.0);
            if (!this.initialized) {
                this.animateSelectionLine();
                this.initialized = true;
            }
        }

        private void animateSelectionLine() {
            double offset = 0.0;
            double selectedTabOffset = 0.0;
            double selectedTabWidth = 0.0;
            Side side = ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer)) continue;
                TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                if (JFXTabPaneSkin.this.selectedTab != null && JFXTabPaneSkin.this.selectedTab.equals(tabHeader.tab)) {
                    selectedTabOffset = side == Side.LEFT || side == Side.BOTTOM ? -offset - tabHeaderPrefWidth : offset;
                    selectedTabWidth = tabHeaderPrefWidth;
                    break;
                }
                offset += tabHeaderPrefWidth;
            }
            this.runTimeline(selectedTabOffset, selectedTabWidth);
        }

        static /* synthetic */ void lambda$runTimeline$2(HeaderContainer this_, double newWidth, ActionEvent finish) {
            if (this_.rotate.getAngle() != 0.0) {
                this_.rotate.setAngle(0.0);
                this_.selectedTabLine.setTranslateX(this_.selectedTabLine.getTranslateX() - newWidth);
            }
        }

        static /* synthetic */ void lambda$new$1(HeaderContainer this_, ScrollEvent e) {
            this_.updateScrollOffset(this_.scrollOffset + e.getDeltaY() * (double)(this_.JFXTabPaneSkin.this.isHorizontal() ? -1 : 1));
        }

        static /* synthetic */ void lambda$new$0(HeaderContainer this_, Observable observable) {
            this_.updateDirection();
        }
    }
}

